/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.gtwy;

import cnrg.itx.*;
/**
 * A <code>GatewayException</code> is a exception thrown by the various Gateway components.
 * 
 * @author Jason Howes
 * @version 1.0a
 */
public class GatewayException extends ITXException
{
	/**
	 * Class constructor.
	 * 
	 * @param msg exception information.
	 */
	protected GatewayException(String msg)
	{
		super("<GatewayException> :: " + msg);
	}

	/**
	 * Class constructor.
	 */
	protected GatewayException()
	{
		super("<GatewayException>");
	}	
}